using Microsoft.Web.Services;
using Microsoft.Web.Services.Security;

using System;
using System.ComponentModel;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml;

namespace WSS_Signature {
	/// <summary>
	/// La classe StockQuotationService implmente un service Web
	/// simple de cotation d'actions scuris par signature,  l'aide 
	/// de la cl prive d'un certificat X509 dtenu par les clients
	/// de ce service. La requte est rejete si le corps du message
	/// SOAP ne prsente pas de signature dont le jeton de scurit
	/// est reconnu valide.
	/// </summary>
	[WebService(Namespace="urn:WSS-Signature")]
	public class StockQuotationService : WebService {
		public StockQuotationService() {
			//CODEGEN: This call is required by the ASP.NET Web Services Designer
			InitializeComponent();
		}

		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing ) {
			if(disposing && components != null) {
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion

		[WebMethod]
		public float GetQuote(string symbol) {
			// Vrification de la prsence du contexte SOAP.
			SoapContext requestContext = HttpSoapContext.RequestContext;
			if (requestContext == null) {
				throw new ApplicationException("Seules les requtes SOAP sont acceptes.");
			}
			// Vrification des informations de scurit du contexte SOAP.
			if (!IsValid(requestContext)) {
				throw new SoapException("Les informations de scurit reues sont incorrectes.",
					new XmlQualifiedName("Bad.Security", "urn:WSS-Signature"));
			}
			return 55.25F;
		}

		/// <summary>
		/// Cette mthode vrifie que les informations de scurit fournies
		/// par le client via le contexte de requte SOAP sont valides. Elle
		/// recherche la prsence d'une signature utilise pour signer le corps
		/// du message SOAP et dont le jeton de scurit peut tre accept.
		/// </summary>
		/// <param name="context">Le contexte de la requte SOAP.</param>
		/// <returns>Vrai s'il existe un jeton valide pour l'accs  ce service; 
		/// Faux sinon.</returns>
		private bool IsValid(SoapContext context) {
			// Vrification de la prsence d'un jeton de scurit.
			if (context.Security.Tokens.Count == 0) {
				return false;
			}

			bool valid = false;
			// Recherche d'une signature valide.
			for (int i = 0; valid == false && i < context.Security.Elements.Count; i++) {
				Signature signature = context.Security.Elements[i] as Signature;
				// Signature utilise pour signer le corps SOAP ?
				if (signature != null && (signature.SignatureOptions & SignatureOptions.IncludeSoapBody) != 0) {
					X509SecurityToken x509token = signature.SecurityToken as X509SecurityToken;
					if (x509token != null) {
						// Vrification des autorisations associes (ici, on considre que
						// tous les accs sont permis). 
						valid = true;
					}
				}
			}
			return valid;
		}
	}
}
